
///////////////////////////////////////////////////////////////////////////////
//
//   CONEXANT SYSTEMS INC - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1137.C - Message 1137 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1137 messages.
//
//
//   REVISION HISTORY
//
//
//   $Log:   V:\Projects\Labmon\Source\Archives\msg1137.c_v  $ 
//   
//      Rev 1.0   08 Dec 1999 14:42:42   dangmk
//    
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);
extern FILE *vEEPROMFilePtr;
extern tUSHORT TempStore[1024];   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1137 message from the ZMsgBuf.
//
void Dec1137(tMSGBUF *ZMsgBuf, tMSG1137 *Msg)
{
   int i;
	unsigned char Buf[30] = {0};
	 
//	for(i=0; i<128; i++) {
//		c = (Msg->Data[i] & 0x00FF);
//		fputc(c, vEEPROMFilePtr);
//		c = ((Msg->Data[i] & 0xFF00) >> 8);
//		fputc(c, vEEPROMFilePtr);
//	}
		
//	if(Msg->BlockID == Msg->BlockTotal - 1) {
//		fclose(vEEPROMFilePtr);          
//		return;
//	}

   // Show BlockID for each 1137
   sprintf(Buf,"BlockID : %d",Msg->BlockID);
   ShowText(Buf,35,25);

	for(i=0; i<128; i++)
        TempStore[Msg->BlockID*128+i] = Msg->Data[i];
        
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1137 message in the ZMsgBuf. 
//
void Bld1137(tMSGBUF *ZMsgBuf, tMSG1137 *Msg)
{
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1137 message from the ZMsgBuf.
//
void Show1137(tMSG1137 *Msg)
{
}                                                 
